<?php

namespace App\Models\Company;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Warehouse extends Model 
{

    protected $table = 'company_warehouses';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'company_id', 'longitude', 'district_id', 'city_id', 'mobile_phone_number');
    protected $visible = array('name', 'company_id', 'longitude', 'district_id', 'city_id', 'mobile_phone_number');

    public function city()
    {
        return $this->belongsTo('App\Models\City');
    }

    public function district()
    {
        return $this->belongsTo('App\Models\District');
    }

    public function company()
    {
        return $this->belongsTo('App\Models\Company');
    }

}